﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxyForLoader.h>
#include <nn/fssrv/sf/fssrv_IProgramRegistry.h>
#include <nn/fssrv/fssrv_FileSystemProxyImpl.h>

namespace nn { namespace fssrv { namespace detail {

    nn::sf::EmplacedRef<nn::fssrv::sf::IFileSystemProxy, nn::fssrv::FileSystemProxyImpl> GetFileSystemProxyServiceObject() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxyForLoader> GetFileSystemProxyForLoaderServiceObject() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxyForLoader> GetInvalidFileSystemProxyForLoaderServiceObject() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> GetProgramRegistryServiceObject() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> GetInvalidProgramRegistryServiceObject() NN_NOEXCEPT;

}}}
