﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  システムデータ更新通知関連 API の宣言
*/


#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_IEventNotifier.h>

namespace nn { namespace fs {

//! @name システムデータ更新通知関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      システムデータ更新通知設定のためのインターフェイスを取得します。
*
*   @param[out] outValue   取得されたインターフェイス
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                   成功しました。
*
*   @pre
*       - outValue が有効なメモリを指している。
*/
Result OpenSystemDataUpdateEventNotifier(std::unique_ptr<IEventNotifier>* outValue) NN_NOEXCEPT;

}}
