﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/crypto/crypto_Sha256Generator.h>

namespace nn { namespace ncm {
    struct ApplicationId;
}}

namespace nn { namespace fs {

namespace fsa {
    class IFileSystem;
    class IFile;
}

Result MountDeviceSaveData(const char* name, const nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;

// 以下、内部実装用定義

namespace detail {
    const uint32_t ThumbnailFileSize = crypto::Sha256Generator::HashSize * 3 + 256 * 1024;
    const uint32_t BcatSaveDataJournalSize = 2 * 1024 * 1024; // TORIAEZU: 2MB
    const int32_t DefaultSaveDataBlockSize = 16 * 1024;
    const int CommittableCountMax = 10;
}

Result MountSaveData(const char* name, UserId userId) NN_NOEXCEPT;
Result MountSaveData(const char* name, const nn::ncm::ApplicationId applicationId, UserId userId) NN_NOEXCEPT;
Result MountSaveDataReadOnly(const char* name, const nn::ncm::ApplicationId applicationId, UserId userId) NN_NOEXCEPT;
bool IsSaveDataExisting(const UserId& userId) NN_NOEXCEPT;
bool IsSaveDataExisting(const nn::ncm::ApplicationId applicationId, const UserId& userId) NN_NOEXCEPT;

Result OpenSaveDataThumbnailFile(std::unique_ptr<nn::fs::fsa::IFile>* outValue, Bit64 applicationId, UserId& userId) NN_NOEXCEPT;
Result ReadSaveDataThumbnailFile(Bit64 applicationId, UserId userId , void* headerData, size_t headerSize, void* bodyData, size_t bodySize) NN_NOEXCEPT;
Result ReadSaveDataThumbnailFileHeader(Bit64 applicationId, UserId userId , void* headerData, size_t headerSize) NN_NOEXCEPT;
Result WriteSaveDataThumbnailFile(Bit64 applicationId, UserId userId , const void* headerData, size_t headerSize, const void* bodyData, size_t bodySize) NN_NOEXCEPT;
Result WriteSaveDataThumbnailFileHeader(Bit64 applicationId, UserId userId , const void* headerData, size_t headerSize) NN_NOEXCEPT;

Result CorruptSaveDataThumbnailFileForDebug(Bit64 applicationId, UserId userId) NN_NOEXCEPT;

Result MountSaveDataInternalStorage(const char* name, SaveDataSpaceId spaceId, SaveDataId saveDataId) NN_NOEXCEPT;
Result OpenSaveDataInternalStorageFileSystem(std::unique_ptr<fsa::IFileSystem>* outValue, SaveDataSpaceId spaceId, SaveDataId saveDataId) NN_NOEXCEPT;
Result CreateSaveData(nn::ncm::ApplicationId applicationId, UserId userId, uint64_t saveDataOwnerId, int64_t size, int64_t journalSize, const nn::fs::HashSalt& salt, uint32_t flags) NN_NOEXCEPT;

}}
