﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  RomFs アーカイブファイル関連 API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace fs {
    struct FileHandle;
}}

namespace nn { namespace fs {

//! @name RomFs アーカイブファイル関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      nn::fs::MountRomOnFile のファイルシステムキャッシュに必要なサイズを取得します。
*
*   @param[out] pOutValue   ファイルシステムキャッシュに必要なサイズ
*   @param[in]  fileHandle  RomFs アーカイブファイルのハンドル
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess        成功しました。
*/
Result QueryMountRomOnFileCacheSize(size_t* pOutValue, FileHandle fileHandle) NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
*   @brief      RomFs アーカイブファイルをマウントします。
*
*   @param[in]  name                      マウント名
*   @param[in]  fileHandle                RomFs アーカイブファイルのハンドル
*   @param[in]  pFileSystemCacheBuffer    ファイルシステムキャッシュのバッファ
*   @param[in]  fileSystemCacheBufferSize バッファのサイズ
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess         成功しました。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*/
Result MountRomOnFile(
    const char* name, FileHandle fileHandle, void* pFileSystemCacheBuffer, size_t fileSystemCacheBufferSize
) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs
