﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace time {
    struct PosixTime;
}}

namespace nn { namespace fs {

/**
*   @brief      システムの現在時刻と時差情報をファイルシステムプロセスに設定します。
*
*   @param[in]  posixTime      システムの現在時刻を指す POSIX 時間
*   @param[in]  timeDifference システムの時差情報（単位は秒）
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                   成功しました。
*   @retval     ResultAllocationMemoryFailed    メモリが不足しています。
*
*/
Result SetCurrentPosixTime(nn::time::PosixTime posixTime, int32_t timeDifference) NN_NOEXCEPT;

}}
