﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  ロゴ領域関連のファイルシステム API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace fs {

//! @name ロゴ領域関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      指定したコンテンツのロゴ領域をマウントします。
*
*   @param[in]  name       マウント名
*   @param[in]  path       コンテンツパス
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*   @retval     ResultPathNotFound          path で表されるコンテンツパスが有効ではありません。
*   @retval     ResultPartitionNotFound     path で表されるコンテンツパスにロゴ領域が存在しません。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*       - path が @link entry_path 有効なパス @endlink である。
*/
Result MountLogo(const char* name, const char* path, ncm::ProgramId programId) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs
