﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  Code FS 関連のファイルシステム API の宣言
*/

#pragma once

#include<nn/nn_Common.h>
#include<nn/nn_Result.h>
#include<nn/ncm/ncm_ProgramId.h>

namespace nn { namespace fs {

//! @name Code FS 関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      指定したプログラムパスに存在するプログラムのコード領域をファイルシステムとしてマウントし、操作できるようにします。
*
*   @details    path には lr から取得したプログラムパスを指定します。
*
*   @param[in]  name       このファイルシステムを表すマウント名
*   @param[in]  path       name に紐付けられるプログラムパス
*   @param[in]  programId  プログラム識別子
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*   @retval     ResultPathNotFound          path で表されるプログラムパスが有効ではありません。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*       - path が @link entry_path 有効なパス @endlink である。
*/
Result MountCode(const char* name, const char* path, ncm::ProgramId programId) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs

