﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  クラウドバックアップ作業領域関連 API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace fs {

/**
* @brief クラウドバックアップ作業領域の識別子です。
*/
enum class CloudBackupWorkStorageId : uint32_t
{
    Nand = 0,
    SdCard,
};

/**
*   @brief クラウドバックアップ作業領域のディレクトリ名です。
*/
const char* const CloudBackupWorkStorageDirectoryName = "cbwork";


/**
*   @brief      ID に紐づいたクラウドバックアップ作業領域をマウントします。
*
*   @param[in]  name       マウント名
*   @param[in]  id         クラウドバックアップ作業領域の識別子
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。

*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*
*   @post
*       - マウント名 name で対象がマウントされている。
*/
Result MountCloudBackupWorkStorage(const char* name, CloudBackupWorkStorageId id) NN_NOEXCEPT;


//! @}

}} // namespace nn::fs
