﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_PriorityPrivate.h>
#include <nn/fs/detail/fs_FsInlineContextUtility.h>

namespace nn { namespace fs { namespace detail {

inline Result ConvertFsPriorityToTlsIoPriority(uint8_t* outValue, PriorityRaw priority) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outValue);
    switch( priority )
    {
    case PriorityRaw_Normal:
        *outValue = 0;
        break;
    case PriorityRaw_Realtime:
        *outValue = 1;
        break;
    case PriorityRaw_Low:
        *outValue = 2;
        break;
    case PriorityRaw_Background:
        *outValue = 3;
        break;
    default:
        NN_RESULT_THROW(ResultInvalidArgument());
    }
    NN_RESULT_SUCCESS;
}

inline Result ConvertTlsIoPriorityToFsPriority(PriorityRaw* outValue, uint8_t priority) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outValue);
    switch( priority )
    {
    case 0:
        *outValue = PriorityRaw_Normal;
        break;
    case 1:
        *outValue = PriorityRaw_Realtime;
        break;
    case 2:
        *outValue = PriorityRaw_Low;
        break;
    case 3:
        *outValue = PriorityRaw_Background;
        break;
    default:
        NN_RESULT_THROW(ResultInvalidArgument());
    }
    NN_RESULT_SUCCESS;
}

inline uint8_t GetTlsIoPriority() NN_NOEXCEPT
{
    return sf::GetFsInlineContext() & TlsIoPriorityMask;
}

}}}
