﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_FsInlineContext.h>

namespace nn { namespace fs { namespace detail {

const uint8_t TlsIoPriorityMask = 0x7;
const uint8_t TlsIoRecursiveCallMask = 0x8;

inline void SetCurrentRequestRecursive() NN_NOEXCEPT
{
    sf::SetFsInlineContext(TlsIoRecursiveCallMask | sf::GetFsInlineContext());
}

inline bool IsCurrentRequestRecursive() NN_NOEXCEPT
{
    return (sf::GetFsInlineContext() & TlsIoRecursiveCallMask) != 0;
}

struct TlsIoValueForInheritance
{
    uint8_t _tlsValue;
};

inline TlsIoValueForInheritance GetTlsIoValueForInheritance() NN_NOEXCEPT
{
    return TlsIoValueForInheritance{ sf::GetFsInlineContext() };
}

inline void SetTlsIoValueForInheritance(TlsIoValueForInheritance tlsValue) NN_NOEXCEPT
{
    sf::SetFsInlineContext(tlsValue._tlsValue);
}

}}}
