﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/eth/eth_EthTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace eth { namespace sf { // NOLINT(whitespace/braces)

class IEthInterface;

class IEthInterfaceGroup;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IEthInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IEthInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut, const ::nn::sf::InBuffer& interfaceName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMediaList, (const ::nn::sf::OutBuffer& mediaListOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMediaType, (::nn::eth::MediaType mediaTypeIn))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMediaType, (::nn::sf::Out<::nn::eth::MediaType> mediaRequested, ::nn::sf::Out<::nn::eth::MediaType> mediaCurrent, ::nn::sf::Out<::std::uint32_t> eventCounter))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IEthInterface)

        ::nn::Result Initialize(::nn::sf::Out<::nn::sf::NativeHandle> handleOut, const ::nn::sf::InBuffer& interfaceName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (handleOut, interfaceName));
        }

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result GetMediaList(const ::nn::sf::OutBuffer& mediaListOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMediaList, (mediaListOut));
        }

        ::nn::Result SetMediaType(::nn::eth::MediaType mediaTypeIn) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMediaType, (mediaTypeIn));
        }

        ::nn::Result GetMediaType(::nn::sf::Out<::nn::eth::MediaType> mediaRequested, ::nn::sf::Out<::nn::eth::MediaType> mediaCurrent, ::nn::sf::Out<::std::uint32_t> eventCounter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMediaType, (mediaRequested, mediaCurrent, eventCounter));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IEthInterface
    {
    public:
        nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, const nn::sf::InBuffer& interfaceName) NN_NOEXCEPT;
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result GetMediaList(const nn::sf::OutBuffer& mediaListOut) NN_NOEXCEPT;
        nn::Result SetMediaType(nn::eth::MediaType mediaTypeIn) NN_NOEXCEPT;
        nn::Result GetMediaType(nn::sf::Out<nn::eth::MediaType> mediaRequested, nn::sf::Out<nn::eth::MediaType> mediaCurrent, nn::sf::Out<std::uint32_t> eventCounter) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, const nn::sf::InBuffer& interfaceName) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result GetMediaList(const nn::sf::OutBuffer& mediaListOut) NN_NOEXCEPT;
    nn::Result SetMediaType(nn::eth::MediaType mediaTypeIn) NN_NOEXCEPT;
    nn::Result GetMediaType(nn::sf::Out<nn::eth::MediaType> mediaRequested, nn::sf::Out<nn::eth::MediaType> mediaCurrent, nn::sf::Out<std::uint32_t> eventCounter) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::eth::sf::IEthInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut, const ::nn::sf::InBuffer& interfaceName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (handleOut, interfaceName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMediaList, (const ::nn::sf::OutBuffer& mediaListOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMediaList, (mediaListOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMediaType, (::nn::eth::MediaType mediaTypeIn))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMediaType, (mediaTypeIn));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMediaType, (::nn::sf::Out<::nn::eth::MediaType> mediaRequested, ::nn::sf::Out<::nn::eth::MediaType> mediaCurrent, ::nn::sf::Out<::std::uint32_t> eventCounter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMediaType, (mediaRequested, mediaCurrent, eventCounter));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::eth::sf::IEthInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::eth::sf::IEthInterface))

    // nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, const nn::sf::InBuffer& interfaceName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(interfaceName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (interfaceName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handleOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interfaceName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result GetMediaList(const nn::sf::OutBuffer& mediaListOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMediaList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(mediaListOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (mediaListOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mediaListOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMediaList)

    // nn::Result SetMediaType(nn::eth::MediaType mediaTypeIn) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMediaType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mediaTypeIn, (::nn::eth::MediaType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mediaTypeIn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mediaTypeIn)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMediaType)

    // nn::Result GetMediaType(nn::sf::Out<nn::eth::MediaType> mediaRequested, nn::sf::Out<nn::eth::MediaType> mediaCurrent, nn::sf::Out<std::uint32_t> eventCounter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMediaType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mediaRequested, (::nn::eth::MediaType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(mediaCurrent, (::nn::eth::MediaType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(eventCounter, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (mediaRequested, mediaCurrent, eventCounter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mediaRequested), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mediaCurrent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventCounter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMediaType)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::eth::MediaType), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::eth::sf::IEthInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::eth::sf::IEthInterface))

    // nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, const nn::sf::InBuffer& interfaceName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut, const ::nn::sf::InBuffer& interfaceName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interfaceName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result GetMediaList(const nn::sf::OutBuffer& mediaListOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMediaList, (const ::nn::sf::OutBuffer& mediaListOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMediaList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mediaListOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMediaList)
    }

    // nn::Result SetMediaType(nn::eth::MediaType mediaTypeIn) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMediaType, (::nn::eth::MediaType mediaTypeIn))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMediaType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mediaTypeIn)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMediaType)
    }

    // nn::Result GetMediaType(nn::sf::Out<nn::eth::MediaType> mediaRequested, nn::sf::Out<nn::eth::MediaType> mediaCurrent, nn::sf::Out<std::uint32_t> eventCounter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMediaType, (::nn::sf::Out<::nn::eth::MediaType> mediaRequested, ::nn::sf::Out<::nn::eth::MediaType> mediaCurrent, ::nn::sf::Out<::std::uint32_t> eventCounter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMediaType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mediaRequested)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mediaCurrent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventCounter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMediaType)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::eth::sf::IEthInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::eth::sf::IEthInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(interfaceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handleOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handleOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(interfaceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMediaList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(mediaListOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMediaList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(mediaListOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMediaType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMediaType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mediaTypeIn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMediaType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMediaType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mediaRequested),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(mediaCurrent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(eventCounter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMediaList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMediaType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMediaType)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::eth::sf::IEthInterface))

namespace nn { namespace eth { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IEthInterfaceGroup, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IEthInterfaceGroup)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceList, (const ::nn::sf::OutBuffer& interfaceListOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceCount, (::nn::sf::Out<::std::uint32_t> interfaceCount))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IEthInterfaceGroup)

        ::nn::Result GetReadableHandle(::nn::sf::Out<::nn::sf::NativeHandle> handleOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReadableHandle, (handleOut));
        }

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result GetInterfaceList(const ::nn::sf::OutBuffer& interfaceListOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterfaceList, (interfaceListOut));
        }

        ::nn::Result GetInterfaceCount(::nn::sf::Out<::std::uint32_t> interfaceCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterfaceCount, (interfaceCount));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IEthInterfaceGroup
    {
    public:
        nn::Result GetReadableHandle(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT;
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result GetInterfaceList(const nn::sf::OutBuffer& interfaceListOut) NN_NOEXCEPT;
        nn::Result GetInterfaceCount(nn::sf::Out<std::uint32_t> interfaceCount) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetReadableHandle(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result GetInterfaceList(const nn::sf::OutBuffer& interfaceListOut) NN_NOEXCEPT;
    nn::Result GetInterfaceCount(nn::sf::Out<std::uint32_t> interfaceCount) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::eth::sf::IEthInterfaceGroup))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReadableHandle, (handleOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceList, (const ::nn::sf::OutBuffer& interfaceListOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterfaceList, (interfaceListOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceCount, (::nn::sf::Out<::std::uint32_t> interfaceCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterfaceCount, (interfaceCount));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::eth::sf::IEthInterfaceGroup>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::eth::sf::IEthInterfaceGroup))

    // nn::Result GetReadableHandle(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReadableHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handleOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handleOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReadableHandle)

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result GetInterfaceList(const nn::sf::OutBuffer& interfaceListOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterfaceList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(interfaceListOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (interfaceListOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interfaceListOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterfaceList)

    // nn::Result GetInterfaceCount(nn::sf::Out<std::uint32_t> interfaceCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterfaceCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(interfaceCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (interfaceCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interfaceCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterfaceCount)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::eth::sf::IEthInterfaceGroup, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::eth::sf::IEthInterfaceGroup))

    // nn::Result GetReadableHandle(nn::sf::Out<nn::sf::NativeHandle> handleOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handleOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReadableHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReadableHandle)
    }

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result GetInterfaceList(const nn::sf::OutBuffer& interfaceListOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceList, (const ::nn::sf::OutBuffer& interfaceListOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterfaceList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interfaceListOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterfaceList)
    }

    // nn::Result GetInterfaceCount(nn::sf::Out<std::uint32_t> interfaceCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterfaceCount, (::nn::sf::Out<::std::uint32_t> interfaceCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterfaceCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interfaceCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterfaceCount)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::eth::sf::IEthInterfaceGroup>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::eth::sf::IEthInterfaceGroup))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handleOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handleOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterfaceList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(interfaceListOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterfaceList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(interfaceListOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterfaceCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterfaceCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(interfaceCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterfaceList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterfaceCount)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::eth::sf::IEthInterfaceGroup))
