﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/dt/dt_Types.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace dt { namespace detail { // NOLINT(whitespace/braces)

class IDeviceTree;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDeviceTree, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDeviceTree)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindNodeByPath, (::nn::sf::Out<::nn::dt::Node> outNode, const ::nn::sf::InBuffer& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindNodeByPHandle, (::nn::sf::Out<::nn::dt::Node> outNode, ::std::uint32_t phandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCompatibleNodeCount, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::InBuffer& compatible))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListCompatibleNode, (const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, const ::nn::sf::InBuffer& compatible))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetParentNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetChildNodeByName, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode, const ::nn::sf::InBuffer& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetChildNodeCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node currentNode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListChildNode, (const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, ::nn::dt::Node currentNode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetValueOfAddressCells, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetValueOfSizeCells, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsPropertyExist, (::nn::sf::Out<bool> outExist, ::nn::dt::Node node, const ::nn::sf::InBuffer& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertySize, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::dt::Node node, const ::nn::sf::InBuffer& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProperty, (const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertyWithIndex, (const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t index, ::std::uint64_t elementSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertyList, (const ::nn::sf::OutBuffer& outArray, ::nn::sf::Out<::std::uint64_t> outPropertySize, ::std::uint64_t maxCount, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node node))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterAddressList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterSizeList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFirstChildNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNextSiblingNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNodePath, (const ::nn::sf::OutBuffer& outPath, ::nn::dt::Node node))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DumpNode, (::nn::dt::Node node, ::std::int32_t depth))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDeviceTree)

        ::nn::Result FindNodeByPath(::nn::sf::Out<::nn::dt::Node> outNode, const ::nn::sf::InBuffer& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindNodeByPath, (outNode, path));
        }

        ::nn::Result FindNodeByPHandle(::nn::sf::Out<::nn::dt::Node> outNode, ::std::uint32_t phandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindNodeByPHandle, (outNode, phandle));
        }

        ::nn::Result GetCompatibleNodeCount(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::InBuffer& compatible) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCompatibleNodeCount, (outCount, compatible));
        }

        ::nn::Result ListCompatibleNode(const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, const ::nn::sf::InBuffer& compatible) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListCompatibleNode, (outNodeList, outCount, maxCount, compatible));
        }

        ::nn::Result GetParentNode(::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetParentNode, (outNode, currentNode));
        }

        ::nn::Result GetChildNodeByName(::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode, const ::nn::sf::InBuffer& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetChildNodeByName, (outNode, currentNode, name));
        }

        ::nn::Result GetChildNodeCount(::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node currentNode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetChildNodeCount, (outCount, currentNode));
        }

        ::nn::Result ListChildNode(const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, ::nn::dt::Node currentNode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListChildNode, (outNodeList, outCount, maxCount, currentNode));
        }

        ::nn::Result GetValueOfAddressCells(::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetValueOfAddressCells, (outValue, node));
        }

        ::nn::Result GetValueOfSizeCells(::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetValueOfSizeCells, (outValue, node));
        }

        ::nn::Result IsPropertyExist(::nn::sf::Out<bool> outExist, ::nn::dt::Node node, const ::nn::sf::InBuffer& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsPropertyExist, (outExist, node, name));
        }

        ::nn::Result GetPropertySize(::nn::sf::Out<::std::uint64_t> outSize, ::nn::dt::Node node, const ::nn::sf::InBuffer& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPropertySize, (outSize, node, name));
        }

        ::nn::Result GetProperty(const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProperty, (outValue, node, name, elementSize));
        }

        ::nn::Result GetPropertyWithIndex(const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t index, ::std::uint64_t elementSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPropertyWithIndex, (outValue, node, name, index, elementSize));
        }

        ::nn::Result GetPropertyList(const ::nn::sf::OutBuffer& outArray, ::nn::sf::Out<::std::uint64_t> outPropertySize, ::std::uint64_t maxCount, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPropertyList, (outArray, outPropertySize, maxCount, node, name, elementSize));
        }

        ::nn::Result GetInterruptCount(::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node node) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterruptCount, (outCount, node));
        }

        ::nn::Result GetInterruptList(const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInterruptList, (outList, outActualCount, maxCount, node));
        }

        ::nn::Result GetRegisterAddressList(const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRegisterAddressList, (outList, outActualCount, maxCount, node, elementSize));
        }

        ::nn::Result GetRegisterSizeList(const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRegisterSizeList, (outList, outActualCount, maxCount, node, elementSize));
        }

        ::nn::Result GetFirstChildNode(::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFirstChildNode, (outNode, currentNode));
        }

        ::nn::Result GetNextSiblingNode(::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNextSiblingNode, (outNode, currentNode));
        }

        ::nn::Result GetNodePath(const ::nn::sf::OutBuffer& outPath, ::nn::dt::Node node) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNodePath, (outPath, node));
        }

        ::nn::Result DumpNode(::nn::dt::Node node, ::std::int32_t depth) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DumpNode, (node, depth));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDeviceTree
    {
    public:
        nn::Result FindNodeByPath(nn::sf::Out<nn::dt::Node> outNode, const nn::sf::InBuffer& path) NN_NOEXCEPT;
        nn::Result FindNodeByPHandle(nn::sf::Out<nn::dt::Node> outNode, std::uint32_t phandle) NN_NOEXCEPT;
        nn::Result GetCompatibleNodeCount(nn::sf::Out<std::uint64_t> outCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT;
        nn::Result ListCompatibleNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT;
        nn::Result GetParentNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
        nn::Result GetChildNodeByName(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode, const nn::sf::InBuffer& name) NN_NOEXCEPT;
        nn::Result GetChildNodeCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node currentNode) NN_NOEXCEPT;
        nn::Result ListChildNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, nn::dt::Node currentNode) NN_NOEXCEPT;
        nn::Result GetValueOfAddressCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT;
        nn::Result GetValueOfSizeCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT;
        nn::Result IsPropertyExist(nn::sf::Out<bool> outExist, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT;
        nn::Result GetPropertySize(nn::sf::Out<std::uint64_t> outSize, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT;
        nn::Result GetProperty(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT;
        nn::Result GetPropertyWithIndex(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t index, std::uint64_t elementSize) NN_NOEXCEPT;
        nn::Result GetPropertyList(const nn::sf::OutBuffer& outArray, nn::sf::Out<std::uint64_t> outPropertySize, std::uint64_t maxCount, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT;
        nn::Result GetInterruptCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node node) NN_NOEXCEPT;
        nn::Result GetInterruptList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node) NN_NOEXCEPT;
        nn::Result GetRegisterAddressList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT;
        nn::Result GetRegisterSizeList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT;
        nn::Result GetFirstChildNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
        nn::Result GetNextSiblingNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
        nn::Result GetNodePath(const nn::sf::OutBuffer& outPath, nn::dt::Node node) NN_NOEXCEPT;
        nn::Result DumpNode(nn::dt::Node node, std::int32_t depth) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result FindNodeByPath(nn::sf::Out<nn::dt::Node> outNode, const nn::sf::InBuffer& path) NN_NOEXCEPT;
    nn::Result FindNodeByPHandle(nn::sf::Out<nn::dt::Node> outNode, std::uint32_t phandle) NN_NOEXCEPT;
    nn::Result GetCompatibleNodeCount(nn::sf::Out<std::uint64_t> outCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT;
    nn::Result ListCompatibleNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT;
    nn::Result GetParentNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetChildNodeByName(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    nn::Result GetChildNodeCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result ListChildNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetValueOfAddressCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result GetValueOfSizeCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result IsPropertyExist(nn::sf::Out<bool> outExist, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    nn::Result GetPropertySize(nn::sf::Out<std::uint64_t> outSize, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    nn::Result GetProperty(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetPropertyWithIndex(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t index, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetPropertyList(const nn::sf::OutBuffer& outArray, nn::sf::Out<std::uint64_t> outPropertySize, std::uint64_t maxCount, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetInterruptCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result GetInterruptList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result GetRegisterAddressList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetRegisterSizeList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetFirstChildNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetNextSiblingNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetNodePath(const nn::sf::OutBuffer& outPath, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result DumpNode(nn::dt::Node node, std::int32_t depth) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::dt::detail::IDeviceTree))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindNodeByPath, (::nn::sf::Out<::nn::dt::Node> outNode, const ::nn::sf::InBuffer& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindNodeByPath, (outNode, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindNodeByPHandle, (::nn::sf::Out<::nn::dt::Node> outNode, ::std::uint32_t phandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindNodeByPHandle, (outNode, phandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompatibleNodeCount, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::InBuffer& compatible))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCompatibleNodeCount, (outCount, compatible));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListCompatibleNode, (const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, const ::nn::sf::InBuffer& compatible))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListCompatibleNode, (outNodeList, outCount, maxCount, compatible));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetParentNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetParentNode, (outNode, currentNode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChildNodeByName, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode, const ::nn::sf::InBuffer& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetChildNodeByName, (outNode, currentNode, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChildNodeCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node currentNode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetChildNodeCount, (outCount, currentNode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListChildNode, (const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, ::nn::dt::Node currentNode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListChildNode, (outNodeList, outCount, maxCount, currentNode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetValueOfAddressCells, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetValueOfAddressCells, (outValue, node));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetValueOfSizeCells, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetValueOfSizeCells, (outValue, node));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPropertyExist, (::nn::sf::Out<bool> outExist, ::nn::dt::Node node, const ::nn::sf::InBuffer& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsPropertyExist, (outExist, node, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertySize, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::dt::Node node, const ::nn::sf::InBuffer& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPropertySize, (outSize, node, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProperty, (const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProperty, (outValue, node, name, elementSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertyWithIndex, (const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t index, ::std::uint64_t elementSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPropertyWithIndex, (outValue, node, name, index, elementSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertyList, (const ::nn::sf::OutBuffer& outArray, ::nn::sf::Out<::std::uint64_t> outPropertySize, ::std::uint64_t maxCount, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPropertyList, (outArray, outPropertySize, maxCount, node, name, elementSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node node))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterruptCount, (outCount, node));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInterruptList, (outList, outActualCount, maxCount, node));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterAddressList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRegisterAddressList, (outList, outActualCount, maxCount, node, elementSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterSizeList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRegisterSizeList, (outList, outActualCount, maxCount, node, elementSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFirstChildNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFirstChildNode, (outNode, currentNode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNextSiblingNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNextSiblingNode, (outNode, currentNode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNodePath, (const ::nn::sf::OutBuffer& outPath, ::nn::dt::Node node))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNodePath, (outPath, node));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DumpNode, (::nn::dt::Node node, ::std::int32_t depth))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DumpNode, (node, depth));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::dt::detail::IDeviceTree>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::dt::detail::IDeviceTree))

    // nn::Result FindNodeByPath(nn::sf::Out<nn::dt::Node> outNode, const nn::sf::InBuffer& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindNodeByPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(path, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindNodeByPath)

    // nn::Result FindNodeByPHandle(nn::sf::Out<nn::dt::Node> outNode, std::uint32_t phandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindNodeByPHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(phandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (phandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(phandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindNodeByPHandle)

    // nn::Result GetCompatibleNodeCount(nn::sf::Out<std::uint64_t> outCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCompatibleNodeCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(compatible, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (compatible))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(compatible)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCompatibleNodeCount)

    // nn::Result ListCompatibleNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListCompatibleNode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNodeList, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(compatible, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outNodeList, compatible))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNodeList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(compatible)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListCompatibleNode)

    // nn::Result GetParentNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetParentNode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(currentNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (currentNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentNode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetParentNode)

    // nn::Result GetChildNodeByName(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetChildNodeByName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(currentNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (currentNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetChildNodeByName)

    // nn::Result GetChildNodeCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetChildNodeCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(currentNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (currentNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentNode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetChildNodeCount)

    // nn::Result ListChildNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListChildNode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNodeList, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNodeList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(currentNode, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (currentNode, maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNodeList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentNode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListChildNode)

    // nn::Result GetValueOfAddressCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetValueOfAddressCells)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (node))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetValueOfAddressCells)

    // nn::Result GetValueOfSizeCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetValueOfSizeCells)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (node))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetValueOfSizeCells)

    // nn::Result IsPropertyExist(nn::sf::Out<bool> outExist, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsPropertyExist)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (node))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outExist, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outExist))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outExist), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsPropertyExist)

    // nn::Result GetPropertySize(nn::sf::Out<std::uint64_t> outSize, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPropertySize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (node))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPropertySize)

    // nn::Result GetProperty(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProperty)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outValue, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outValue, name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(elementSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (node, elementSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elementSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProperty)

    // nn::Result GetPropertyWithIndex(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t index, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPropertyWithIndex)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outValue, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outValue, name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(elementSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (node, index, elementSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elementSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPropertyWithIndex)

    // nn::Result GetPropertyList(const nn::sf::OutBuffer& outArray, nn::sf::Out<std::uint64_t> outPropertySize, std::uint64_t maxCount, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPropertyList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outArray, name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(elementSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (node, maxCount, elementSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outPropertySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outPropertySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPropertySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elementSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPropertyList)

    // nn::Result GetInterruptCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterruptCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (node))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterruptCount)

    // nn::Result GetInterruptList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInterruptList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (node, maxCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outActualCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outActualCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outActualCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInterruptList)

    // nn::Result GetRegisterAddressList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRegisterAddressList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(elementSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (node, maxCount, elementSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outActualCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outActualCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outActualCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elementSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRegisterAddressList)

    // nn::Result GetRegisterSizeList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRegisterSizeList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxCount, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(elementSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (node, maxCount, elementSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outActualCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outActualCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outActualCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elementSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRegisterSizeList)

    // nn::Result GetFirstChildNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFirstChildNode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(currentNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (currentNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentNode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFirstChildNode)

    // nn::Result GetNextSiblingNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNextSiblingNode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(currentNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (currentNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNode, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentNode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNextSiblingNode)

    // nn::Result GetNodePath(const nn::sf::OutBuffer& outPath, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNodePath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outPath, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outPath))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (node))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPath), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNodePath)

    // nn::Result DumpNode(nn::dt::Node node, std::int32_t depth) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DumpNode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(node, (::nn::dt::Node), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(depth, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (node, depth))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(node), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(depth)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DumpNode)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::dt::Node), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::dt::detail::IDeviceTree, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::dt::detail::IDeviceTree))

    // nn::Result FindNodeByPath(nn::sf::Out<nn::dt::Node> outNode, const nn::sf::InBuffer& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindNodeByPath, (::nn::sf::Out<::nn::dt::Node> outNode, const ::nn::sf::InBuffer& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindNodeByPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindNodeByPath)
    }

    // nn::Result FindNodeByPHandle(nn::sf::Out<nn::dt::Node> outNode, std::uint32_t phandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindNodeByPHandle, (::nn::sf::Out<::nn::dt::Node> outNode, ::std::uint32_t phandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindNodeByPHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(phandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindNodeByPHandle)
    }

    // nn::Result GetCompatibleNodeCount(nn::sf::Out<std::uint64_t> outCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompatibleNodeCount, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::InBuffer& compatible))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCompatibleNodeCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(compatible)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCompatibleNodeCount)
    }

    // nn::Result ListCompatibleNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListCompatibleNode, (const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, const ::nn::sf::InBuffer& compatible))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListCompatibleNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNodeList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(compatible)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListCompatibleNode)
    }

    // nn::Result GetParentNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetParentNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetParentNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentNode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetParentNode)
    }

    // nn::Result GetChildNodeByName(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChildNodeByName, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode, const ::nn::sf::InBuffer& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetChildNodeByName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetChildNodeByName)
    }

    // nn::Result GetChildNodeCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChildNodeCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node currentNode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetChildNodeCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentNode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetChildNodeCount)
    }

    // nn::Result ListChildNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListChildNode, (const ::nn::sf::OutBuffer& outNodeList, ::nn::sf::Out<::std::uint64_t> outCount, ::std::uint64_t maxCount, ::nn::dt::Node currentNode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListChildNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNodeList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentNode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListChildNode)
    }

    // nn::Result GetValueOfAddressCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetValueOfAddressCells, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetValueOfAddressCells)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetValueOfAddressCells)
    }

    // nn::Result GetValueOfSizeCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetValueOfSizeCells, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::dt::Node node))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetValueOfSizeCells)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetValueOfSizeCells)
    }

    // nn::Result IsPropertyExist(nn::sf::Out<bool> outExist, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsPropertyExist, (::nn::sf::Out<bool> outExist, ::nn::dt::Node node, const ::nn::sf::InBuffer& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsPropertyExist)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outExist)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsPropertyExist)
    }

    // nn::Result GetPropertySize(nn::sf::Out<std::uint64_t> outSize, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertySize, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::dt::Node node, const ::nn::sf::InBuffer& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPropertySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPropertySize)
    }

    // nn::Result GetProperty(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProperty, (const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProperty)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elementSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProperty)
    }

    // nn::Result GetPropertyWithIndex(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t index, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertyWithIndex, (const ::nn::sf::OutBuffer& outValue, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t index, ::std::uint64_t elementSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPropertyWithIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elementSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPropertyWithIndex)
    }

    // nn::Result GetPropertyList(const nn::sf::OutBuffer& outArray, nn::sf::Out<std::uint64_t> outPropertySize, std::uint64_t maxCount, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPropertyList, (const ::nn::sf::OutBuffer& outArray, ::nn::sf::Out<::std::uint64_t> outPropertySize, ::std::uint64_t maxCount, ::nn::dt::Node node, const ::nn::sf::InBuffer& name, ::std::uint64_t elementSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPropertyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPropertySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elementSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPropertyList)
    }

    // nn::Result GetInterruptCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::dt::Node node))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterruptCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterruptCount)
    }

    // nn::Result GetInterruptList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInterruptList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInterruptList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outActualCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInterruptList)
    }

    // nn::Result GetRegisterAddressList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterAddressList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRegisterAddressList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outActualCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elementSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRegisterAddressList)
    }

    // nn::Result GetRegisterSizeList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRegisterSizeList, (const ::nn::sf::OutBuffer& outList, ::nn::sf::Out<::std::uint64_t> outActualCount, ::std::uint64_t maxCount, ::nn::dt::Node node, ::std::uint64_t elementSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRegisterSizeList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outActualCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elementSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRegisterSizeList)
    }

    // nn::Result GetFirstChildNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFirstChildNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFirstChildNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentNode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFirstChildNode)
    }

    // nn::Result GetNextSiblingNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNextSiblingNode, (::nn::sf::Out<::nn::dt::Node> outNode, ::nn::dt::Node currentNode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNextSiblingNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentNode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNextSiblingNode)
    }

    // nn::Result GetNodePath(const nn::sf::OutBuffer& outPath, nn::dt::Node node) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNodePath, (const ::nn::sf::OutBuffer& outPath, ::nn::dt::Node node))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNodePath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNodePath)
    }

    // nn::Result DumpNode(nn::dt::Node node, std::int32_t depth) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DumpNode, (::nn::dt::Node node, ::std::int32_t depth))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DumpNode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(node)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(depth)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DumpNode)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::dt::detail::IDeviceTree>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::dt::detail::IDeviceTree))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindNodeByPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindNodeByPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindNodeByPHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindNodeByPHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(phandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCompatibleNodeCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(compatible)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCompatibleNodeCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(compatible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListCompatibleNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNodeList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(compatible)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListCompatibleNode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNodeList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(compatible)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetParentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetParentNode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(currentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetChildNodeByName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetChildNodeByName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(currentNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetChildNodeCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetChildNodeCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(currentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListChildNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNodeList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListChildNode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNodeList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(currentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetValueOfAddressCells)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetValueOfAddressCells)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetValueOfSizeCells)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetValueOfSizeCells)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsPropertyExist)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsPropertyExist)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outExist),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPropertySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPropertySize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProperty)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(elementSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPropertyWithIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPropertyWithIndex)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(elementSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPropertyList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPropertyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outPropertySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(elementSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterruptCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterruptCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInterruptList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInterruptList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outActualCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRegisterAddressList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRegisterAddressList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outActualCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(elementSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRegisterSizeList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRegisterSizeList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outActualCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(elementSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFirstChildNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFirstChildNode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(currentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNextSiblingNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNextSiblingNode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(currentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNodePath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNodePath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outPath),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DumpNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DumpNode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(node),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(depth)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindNodeByPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindNodeByPHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCompatibleNodeCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListCompatibleNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetParentNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetChildNodeByName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetChildNodeCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListChildNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetValueOfAddressCells)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetValueOfSizeCells)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsPropertyExist)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPropertySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPropertyWithIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPropertyList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterruptCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInterruptList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRegisterAddressList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRegisterSizeList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFirstChildNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNextSiblingNode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNodePath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DumpNode)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::dt::detail::IDeviceTree))
