﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/net/osl/osl_Mbuf.h>

namespace nn { namespace drivers { namespace eth {

// Ethernet フレームを受信した
typedef void (*FrameReceivedCallBack)(const void* frameData, int frameBytes);
// ネットワークに送出された（受信されたかどうかはわからない）
// data: Send に与えたデータ
typedef void (*SendCompletedCallBack)(void* frameData);
//typedef void (*NotificationCallBack)(Type Type);

typedef enum
{
    InterfaceState_Invalid,
    InterfaceState_NoDevice,
    InterfaceState_LinkDown,
    InterfaceState_LinkUp
}InterfaceState;
typedef void (*InterfaceStateCallBack)(InterfaceState state);

nn::Result Initialize();

// Ethernetフレームを受信したときに呼ばれるコールバックを登録します
// ドライバ内のスレッドから呼び出されます。
void RegisterFrameReceivedCallBack(FrameReceivedCallBack callBack);
void UnregisterFrameReceivedCallBack();

// Ethernetフレームをデバイスの送信バッファに追加したときに呼ばれるコールバックを登録します
// ドライバ内のスレッドから呼び出されます。※現状の実装では、Sendを呼び出したスレッドから呼び出されます
void RegisterSendCompletedCallBack(SendCompletedCallBack callBack);
void UnregisterSendCompletedCallBack();

nn::Result GetMacAddress(uint8_t pMacAddress[NN_NET_MAC_ADDRESS_SIZE]);

// Ethernet フレーム（FCSはデバイスが付加します）を送信する
// frameData/pMbuf が指すバッファは、そのバッファに対して SendCompletedCallBack が呼ばれるまで解放しないでください。
// TORIAEZU: 制限: frameData は4バイトアラインされている必要があります。
nn::Result Send(const void* frameData, int frameBytes);
nn::Result Send(nnnetOslMbuf* pMbuf);
nn::Result Send(int32_t numSegments, uint8_t **segmentBuffers, size_t *segmentSizes);

void RegisterInterfaceStateCallBack(InterfaceStateCallBack callback);
void UnregisterInterfaceStateCallBack();

nn::Result Finalize();

}}}

