﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_BitTypes.h>
#include <nn/os/os_Types.h>
#include <nn/svc/svc_Handle.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn {
namespace dmnt0 {

    namespace detail
    {
        const char PortName[] = "dmnt0:-";
    }

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    Result DebugNewProcess(nn::svc::Handle* pOut, nn::os::ProcessId* pId, ncm::ProgramId programId, int port) NN_NOEXCEPT;
    Result AttachProcess(nn::svc::Handle* pOut, nn::os::ProcessId processId, int port) NN_NOEXCEPT;


} // end of namespace ldr
} // end of namespace nn
