﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/diag/diag_LogTypes.h>

namespace nn { namespace diag {

void OnResultThrow(Result result, const SourceInfo& sourceInfo) NN_NOEXCEPT;
void OnResultHandle(Result result, const SourceInfo& sourceInfo) NN_NOEXCEPT;
void OnResultRethrow(Result result, const SourceInfo& sourceInfo) NN_NOEXCEPT;
void OnResultCatch(Result result, const SourceInfo& sourceInfo) NN_NOEXCEPT;
void OnResultMiss(Result result, const SourceInfo& sourceInfo) NN_NOEXCEPT;

}}
