﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/devicecode/devicecode_Builder.h>

#define NN_DETAIL_DEVICECODE_GPIO_PORT_A 0 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_B 1 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_C 2 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_D 3 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_E 4 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_F 5 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_G 6 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_H 7 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_I 8 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_J 9 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_K 10 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_L 11 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_M 12 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_N 13 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_O 14 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_P 15 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_Q 16 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_R 17 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_S 18 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_T 19 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_U 20 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_V 21 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_W 22 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_X 23 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_Y 24 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_Z 25 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_AA 26 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_BB 27 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_CC 28 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_DD 29 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_EE 30 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_FF 31 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_PORT_COUNT 32 // NOLINT(preprocessor/const)

#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_0 0 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_1 1 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_2 2 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_3 3 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_4 4 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_5 5 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_6 6 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_7 7 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_GPIO_OFFSET_COUNT 8 // NOLINT(preprocessor/const)

#define NN_DETAIL_DEVICECODE_GPIO_TEGRA_PAD_NUM(port, offset) ((NN_DETAIL_DEVICECODE_GPIO_PORT_##port) * 8 + (NN_DETAIL_DEVICECODE_GPIO_OFFSET_##offset))

/**
 * @brief Tegra 向けの GPIO パッドが専有する InnerID の上限値（この値を含まない）
 */
#define NN_DETAIL_DEVICECODE_GPIO_TEGRA_PAD_INNERID_MAX  (NN_DETAIL_DEVICECODE_GPIO_PORT_COUNT * 8)

/**
 * @brief Tegra 向けの GPIO パッドのデバイスコード
 */
#define NN_DEVICECODE_GPIO_TEGRA_PAD(port, offset) NN_DEVICECODE_MAKE_CODE(GPIO, NN_DETAIL_DEVICECODE_GPIO_TEGRA_PAD_NUM(port, offset))
