﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief デバイスコードを定義するための機能の宣言
 */

#include <nn/devicecode/devicecode_Categories.h>
#include <nn/devicecode/detail/devicecode_BuilderImpl.h>

#if defined(NN_BUILD_FOR_DOCUMENT_GENERATION)

/**
 * @brief デバイスコードを生成します。
 * @param[in] category  カテゴリ名（文字列）。 NN_DEVICECODE_CATEGORY_##category が <nn/devicecode/devicecode_Categories.h> に定義されている必要があります。
 * @param[in] innerId   InnerID。有効な値の範囲は 0x0000 ～ 0xffff です。
 */
#define NN_DEVICECODE_MAKE_CODE(category, innerId)

#else // defined(NN_BUILD_FOR_DOCUMENT_GENERATION)

#define NN_DEVICECODE_MAKE_CODE(category, innerId) \
    NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL((NN_DEVICECODE_CATEGORY_##category), innerId)

#endif // defined(NN_BUILD_FOR_DOCUMENT_GENERATION)
