﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Bit 0:15 : Inner ID
#define NN_DETAIL_DEVICECODE_INNERID_SHIFT  0 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_INNERID_MASK   0x0000ffff // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_MAKE_INNERID(index) \
    (((index) << NN_DETAIL_DEVICECODE_INNERID_SHIFT) & NN_DETAIL_DEVICECODE_INNERID_MASK)
#define NN_DETAIL_DEVICECODE_GET_INNERID(devicecode) \
    (((devicecode) & NN_DETAIL_DEVICECODE_INNERID_MASK) >> NN_DETAIL_DEVICECODE_INNERID_SHIFT)

#if !defined(__DTS__)
#define NN_DETAIL_DEVICECODE_IS_INNERID_IN_VALID_RANGE(index) \
    (((index) & ~(NN_DETAIL_DEVICECODE_INNERID_MASK >> NN_DETAIL_DEVICECODE_INNERID_SHIFT)) == 0)
#endif // __DTS__

// Bit 16:23 : RESERVED

// Bit 24:31 : Category
#define NN_DETAIL_DEVICECODE_CATEGORY_SHIFT 24 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_CATEGORY_MASK  0xff000000 // NOLINT(preprocessor/const)
#define NN_DETAIL_DEVICECODE_MAKE_CATEGORY(category) \
    (((category) << NN_DETAIL_DEVICECODE_CATEGORY_SHIFT) & NN_DETAIL_DEVICECODE_CATEGORY_MASK)
#define NN_DETAIL_DEVICECODE_GET_CATEGORY(devicecode) \
    (((devicecode) & NN_DETAIL_DEVICECODE_CATEGORY_MASK) >> NN_DETAIL_DEVICECODE_CATEGORY_SHIFT)

#if !defined(__DTS__)
#define NN_DETAIL_DEVICECODE_IS_CATEGORY_IN_VALID_RANGE(index) \
    (((index) & ~(NN_DETAIL_DEVICECODE_CATEGORY_MASK >> NN_DETAIL_DEVICECODE_CATEGORY_SHIFT)) == 0)
#endif // __DTS__
