﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/devicecode/detail/devicecode_InnerFormat.h>

#define NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(category, innerId) \
    (NN_DETAIL_DEVICECODE_MAKE_CATEGORY(category) | (NN_DETAIL_DEVICECODE_MAKE_INNERID(innerId)))

#if defined(__cplusplus)

#include <nn/nn_SdkAssert.h>
#include <nn/nn_DeviceCode.h>

namespace nn { namespace devicecode { namespace detail {

    // C/C++ 側から呼び出した場合に限り、値のレンジが適正かチェックを行う
    NN_FORCEINLINE nn::DeviceCode MakeDeviceCodeImpl(nn::DeviceCode::Category category, nn::DeviceCode::InnerId innerId) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(NN_DETAIL_DEVICECODE_IS_CATEGORY_IN_VALID_RANGE(category), "category %d is not in valid range\n", category);
        NN_SDK_ASSERT(NN_DETAIL_DEVICECODE_IS_INNERID_IN_VALID_RANGE(innerId), "innerId %d is not in valid range\n", innerId);
        return nn::DeviceCode(NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(category, innerId));
    }

}}} // nn::devicecode::detail

#define NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL(category, innerId) \
    ::nn::devicecode::detail::MakeDeviceCodeImpl(category, innerId)

#elif !defined(__DTS__)

#include <nnc/nn_Common.h>
// #include <nnc/nn_SdkAssert.h> // TODO: 今存在しない
#include <nnc/nn_DeviceCode.h>

// C/C++ 側から呼び出した場合に限り、値のレンジが適正かチェックを行う
static NNC_FORCEINLINE nnDeviceCode nndetailDevicecodeMakeDeviceCodeImpl(nnDeviceCodeCategory category, nnDeviceCodeInnerId innerId)
{
    // TODO: NNC_SDK_ASSERT は今存在しないので、存在したら対応したい
    // NNC_SDK_ASSERT(NN_DETAIL_DEVICECODE_IS_CATEGORY_IN_VALID_RANGE(category), "category %d is not in valid range\n", category);
    // NNC_SDK_ASSERT(NN_DETAIL_DEVICECODE_IS_INNERID_IN_VALID_RANGE(innerId), "innerId %d is not in valid range\n", innerId);
    return nnDeviceCodeMakeCode(NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(category, innerId));
}

#define NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL(category, innerId) \
    nndetailDevicecodeMakeDeviceCodeImpl(category, innerId)

#else // __DTS__

// DeviceTree からの参照ではレンジチェックしない
#define NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL(category, innerId) \
    NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(category, innerId)

#endif
