﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

namespace nn { namespace dd {

#if defined(NN_BUILD_CONFIG_OS_HORIZON) && defined(NN_BUILD_CONFIG_SOC_TEGRA_X1) || defined(NN_BUILD_FOR_DOCUMENT_GENERATION)
//-----------------------------------------------------------------------------
/**
 * @brief   Tegra X1 環境におけるデバイスグループの名前を表す列挙型です
 *
 * @details
 *  SW Group については LSI の Technical Reference Manual を参照して下さい。
 *
 */
enum DeviceName
{
    DeviceName_Afi,         //!< SW Group: AFI のデバイス名
    DeviceName_Avpc,        //!< SW Group: AVPC のデバイス名
    DeviceName_Dc,          //!< SW Group: DC のデバイス名
    DeviceName_Dcb,         //!< SW Group: DCB のデバイス名
    DeviceName_Hc,          //!< SW Group: HC のデバイス名
    DeviceName_Hda,         //!< SW Group: HDA のデバイス名
    DeviceName_Isp2,        //!< SW Group: ISP2 のデバイス名
    DeviceName_Nvenc,       //!< SW Group: NVENC のデバイス名
    DeviceName_Nv,          //!< SW Group: （詳細不明）
    DeviceName_Nv2,         //!< SW Group: （詳細不明）
    DeviceName_Ppcs,        //!< SW Group: PPCS のデバイス名
    DeviceName_Sata,        //!< SW Group: SATA のデバイス名
    DeviceName_Vi,          //!< SW Group: VI のデバイス名
    DeviceName_Vic,         //!< SW Group: VIC のデバイス名
    DeviceName_XusbHost,    //!< SW Group: XUSB_HOST のデバイス名
    DeviceName_XusbDev,     //!< SW Group: XUSB_DEV のデバイス名
    DeviceName_Tsec,        //!< SW Group: TSEC のデバイス名
    DeviceName_Ppcs1,       //!< SW Group: （詳細不明）
    DeviceName_Dc1,         //!< SW Group: （詳細不明）
    DeviceName_Sdmmc1a,     //!< SW Group: SDMMC1a のデバイス名
    DeviceName_Sdmmc2a,     //!< SW Group: SDMMC2a のデバイス名
    DeviceName_Sdmmc3a,     //!< SW Group: SDMMC3a のデバイス名
    DeviceName_Sdmmc4a,     //!< SW Group: SDMMC4a のデバイス名
    DeviceName_Isp2b,       //!< SW Group: ISP2B のデバイス名
    DeviceName_Gpu,         //!< SW Group: GPU のデバイス名
    DeviceName_Gpub,        //!< SW Group: （詳細不明）
    DeviceName_Ppcs2,       //!< SW Group: （詳細不明）
    DeviceName_Nvdec,       //!< SW Group: NVDEC のデバイス名
    DeviceName_Ape,         //!< SW Group: APE のデバイス名
    DeviceName_Se,          //!< SW Group: SE のデバイス名
    DeviceName_Nvjpg,       //!< SW Group: NVJPG のデバイス名
    DeviceName_Hc1,         //!< SW Group: （詳細不明）
    DeviceName_Se1,         //!< SW Group: （詳細不明）
    DeviceName_Axiap,       //!< SW Group: AXIAP のデバイス名
    DeviceName_Etr,         //!< SW Group: ETR のデバイス名
    DeviceName_Tsecb,       //!< SW Group: TSECB のデバイス名
    DeviceName_Tsec1,       //!< SW Group: （詳細不明）
    DeviceName_Tsecb1,      //!< SW Group: （詳細不明）
    DeviceName_Nvdec1,      //!< SW Group: （詳細不明）

    DeviceName_Num
};
#endif

}}  // namespace nn::dd

