﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   DD 関連オブジェクトの定義で使用するマクロ定義
 */

#pragma once

#include <nn/dd/dd_Config.h>

//--------------------------------------------------------------------------

#if defined(NN_BUILD_CONFIG_COMPILER_CLANG) || \
    defined(NN_BUILD_CONFIG_COMPILER_GCC)   || \
    defined(NN_BUILD_CONFIG_COMPILER_VC)

#include <type_traits>
#undef  NN_BUILD_CONFIG_COMPILER_SUPPORTS_STD_IS_TRIVIAL
#define NN_BUILD_CONFIG_COMPILER_SUPPORTS_STD_IS_TRIVIAL    1

#endif  // CLANG or GCC or VC++


//  name で指定された型が trivial かどうかをコンパイル時に判定する
#if defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_STD_IS_TRIVIAL)
    #define NN_DD_STATIC_ASSERT_TRIVIAL(name) \
            static_assert(std::is_trivial<name>::value, #name" is non-trivial.")
#else
    #define NN_DD_STATIC_ASSERT_TRIVIAL(name)
#endif


//  外部リンケージを C で宣言する
#define NN_DD_EXTERN_C  extern "C"

//  cppname 同等のサイズとアライメントを持つオブジェクトを cname で定義する
#define NN_DD_DEFINE_ALIGNED_STORAGE(cname, cppname, size, alignment_type)  \
        typedef union cname                                                 \
        {                                                                   \
            uint8_t         buf[size];                                      \
            alignment_type  alignment_holder;                               \
        } cname

