﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief DHCP Client Public API
 *
 * @details
 */
namespace nn { namespace bsdsocket { namespace dhcpc {


/**
 * @brief Prepare DHCP Client subsystem for use
 * @pre
 * @post
 * @details
 */
Result Initialize();

/**
 * @brief Stop DHCP Client subsystem, stoppihng all client
 *        instances
 * @pre
 * @post
 * @details
 */
Result Finalize();

/**
 * @brief Start DHCP Client operation for the specified
 *        interface name
 * @pre
 * @post
 * @details
 */
Result InitializeClient(int32_t ifIndex,
                        const InterfaceConfigType *pIfConfig);

/**
 * @brief Stop DHCP Client operation for the specified
 *        interface name
 * @pre
 * @post
 * @details
 */
Result FinalizeClient(int32_t ifIndex, uint32_t options);


/**
 * @brief Get specified DHCP option data
 * @pre
 * @post
 * @details
 */
Result GetOptionData(int32_t ifIndex, DhcpProtOption option,
                     void *pRetData, size_t bufferSize, size_t *pRetSize);


/**
 * @brief Get current state of DHCP client
 * @pre
 * @post
 * @details
 */
Result GetState(int32_t ifIndex, char *pReturnedStateName, size_t stateNameSizeLimit);


/**
 * @brief Set current state of DHCP client to renew
 * @pre
 * @post
 * @details
 */
Result ForceRenew(int32_t ifIndex);

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn





