﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      bsdsocket モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_BSDSOCKET_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_BSDSOCKET_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_BSDSOCKET_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_BSDSOCKET_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_BSDSOCKET_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_BSDSOCKET_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bsdsocket, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_BSDSOCKET_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Trace, 0, format, args)
#define NN_DETAIL_BSDSOCKET_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Trace, 1, format, args)
#define NN_DETAIL_BSDSOCKET_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Trace, 2, format, args)
#define NN_DETAIL_BSDSOCKET_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Trace, 3, format, args)

#define NN_DETAIL_BSDSOCKET_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Info, 0, format, args)
#define NN_DETAIL_BSDSOCKET_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Info, 1, format, args)
#define NN_DETAIL_BSDSOCKET_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Info, 2, format, args)
#define NN_DETAIL_BSDSOCKET_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Info, 3, format, args)

#define NN_DETAIL_BSDSOCKET_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Warn, 0, format, args)
#define NN_DETAIL_BSDSOCKET_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Warn, 1, format, args)
#define NN_DETAIL_BSDSOCKET_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Warn, 2, format, args)
#define NN_DETAIL_BSDSOCKET_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Warn, 3, format, args)

#define NN_DETAIL_BSDSOCKET_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Error, 0, format, args)
#define NN_DETAIL_BSDSOCKET_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Error, 1, format, args)
#define NN_DETAIL_BSDSOCKET_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Error, 2, format, args)
#define NN_DETAIL_BSDSOCKET_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Error, 3, format, args)

#define NN_DETAIL_BSDSOCKET_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Fatal, 0, format, args)
#define NN_DETAIL_BSDSOCKET_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Fatal, 1, format, args)
#define NN_DETAIL_BSDSOCKET_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Fatal, 2, format, args)
#define NN_DETAIL_BSDSOCKET_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bsdsocket, Fatal, 3, format, args)

#define NN_DETAIL_BSDSOCKET_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Trace, 0, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Trace, 1, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Trace, 2, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Trace, 3, text, length)

#define NN_DETAIL_BSDSOCKET_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Info, 0, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Info, 1, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Info, 2, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Info, 3, text, length)

#define NN_DETAIL_BSDSOCKET_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Warn, 0, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Warn, 1, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Warn, 2, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Warn, 3, text, length)

#define NN_DETAIL_BSDSOCKET_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Error, 0, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Error, 1, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Error, 2, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Error, 3, text, length)

#define NN_DETAIL_BSDSOCKET_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Fatal, 0, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Fatal, 1, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Fatal, 2, text, length)
#define NN_DETAIL_BSDSOCKET_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bsdsocket, Fatal, 3, text, length)
