﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <string>
#include <Windows.h>
#include "VsRegConfig.h"

std::string VsVersionString = "15.0";
std::string VsConfigName = "";
std::string VsInstanceId = "";


void Usage()
{
#if defined(_DEBUG)
    fprintf(stderr, "Usage: VsRegConfig [config name] [VS version] [VS instanceId]");
#endif
}

BOOL ParseArgument(int argc, char** argv[])
{
    if (argc <= 3)
    {
        return FALSE;
    }

    VsConfigName = (*argv)[1];
    VsVersionString = (*argv)[2];
    VsInstanceId = (*argv)[3];

    return TRUE;
}

int main(int argc, char* argv[])
{
    if (!ParseArgument(argc, &argv))
    {
        Usage();
        return 1;
    }

    // printf("config : %s, ver : %s, instance : %s\n", VsConfigName.c_str(), VsVersionString.c_str(), VsInstanceId.c_str());

    return ReadVsRegistoryConfig(VsConfigName, VsVersionString, VsInstanceId);
}

