﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "VsRegConfig.h"
#include <string>
#include <Windows.h>
#include <tchar.h>
#include <shlwapi.h>

// VS レジストリから ConfigKeyName を読み込んでログ表示する
// 戻り値 : 0 - 成功, 非0 - 失敗
int ReadVsRegistoryConfig(std::string ConfigKeyName, std::string VsVersion, std::string VsInstanceId)
{
    std::wstring sConfigKeyName = s2ws(ConfigKeyName);
    std::wstring sVsVersion = s2ws(VsVersion);
    std::wstring sVsInstanceId = s2ws(VsInstanceId);

    // レジストリ・ハイブをロードする
    TCHAR RegFilePath[MAX_PATH];
    TCHAR localAppDataDir[MAX_PATH];
    GetEnvironmentVariable(_T("LocalAppData"), localAppDataDir, MAX_PATH);
    _stprintf_s(RegFilePath, MAX_PATH, _T("%s\\Microsoft\\VisualStudio\\%s_%s\\privateregistry.bin"), localAppDataDir, sVsVersion.c_str(), sVsInstanceId.c_str());
    struct _stat64i32 dummyStat;
    int iRet = _tstat(RegFilePath, &dummyStat);
    if (iRet != 0)
    {
        _ftprintf(stderr, _T("File not found (%s)\n"), RegFilePath);
        return 1;
    }

    LONG lResult;
    HKEY hKey;
    lResult = RegLoadAppKey(RegFilePath, &hKey, KEY_READ, NULL, NULL);
    if (lResult != ERROR_SUCCESS)
    {
        fprintf(stderr, "RegLoadAppKey error (%08x)\n", lResult);
        DisplayErrorNo(lResult);
        return 1;
    }

    // ConfigKeyName を読み込んでログに表示する
    const int SugKeySize = 256;
    const int ValueSize = 1024;
    TCHAR subKey[SugKeySize];
    TCHAR value[ValueSize];
    DWORD bufferSize = ValueSize;
    DWORD dwType;
    _stprintf_s(subKey, SugKeySize, _T("Software\\Microsoft\\VisualStudio\\%s_%s"), sVsVersion.c_str(), sVsInstanceId.c_str());

    lResult = RegGetValue(hKey, subKey, sConfigKeyName.c_str(), RRF_RT_ANY, &dwType, value, &bufferSize);
    if (lResult != ERROR_SUCCESS)
    {
        fprintf(stderr, "RegGetValue error (%08x)\n", lResult);
        DisplayErrorNo(lResult);
        return 1;
    }
    _tprintf(TEXT("%s"), value);

    // レジストリ・ハイブをアンロードする
    lResult = RegCloseKey(hKey);
    if (lResult != ERROR_SUCCESS)
    {
        fprintf(stderr, "RegCloseKey error (%08x)\n", lResult);
        DisplayErrorNo(lResult);
        return 1;
    }

    return 0;
}
