﻿using LibGit2Sharp;
using System;
using System.Collections.Generic;
using System.Linq;

namespace SigloNact.Utilities
{
    public static class GitUtilities
    {
        /// <summary>
        /// 指定したコミットの情報を取得します。
        /// </summary>
        /// <param name="rootPath">リポジトリのルート</param>
        /// <param name="rev">情報を取得するリビジョン</param>
        /// <returns>GitRevisionInfo</returns>
        public static GitRevisionInfo GetGitRevisionInfo(string rootPath, string rev)
        {
            using (var repo = new Repository(rootPath))
            {
                repo.RevParse(rev, out var reference, out var gitobj);

                if (!(gitobj is Commit))
                {
                    throw new ArgumentException(string.Format("'{0}' is not commit hash.", rev), nameof(rev));
                }

                var commit = gitobj as Commit;
                var number = repo.Commits.QueryBy(new CommitFilter() { IncludeReachableFrom = commit }).Count();
                var branch = repo.Head.FriendlyName;
                var hash = gitobj.Sha;
                return new GitRevisionInfo(hash, branch, number, commit.Committer.When.ToUniversalTime());
            }
        }
    }
}
