﻿using Nintendo.Nact;
using Nintendo.Nact.ClassSystem;
using Nintendo.Nact.Evaluation;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Values;
using System;
using System.Linq;
using static Nintendo.Nact.Extensions.NactValueExtensions;

namespace SigloNact.Utilities
{
    static class GetDeleteObsoleteFilesTargetsUtil
    {
        public static FilePath[] GetDeleteTargetDirectories(EvaluationState evaluationState, BuildTaskTree buildTaskTree, string variableName)
        {
            FilePath[] directories;
            {
                BuildNode rootNode;
                if (!buildTaskTree.BuildNodeCollection.TryGetNodeByPath(buildTaskTree.RootRulePath, out rootNode))
                {
                    throw new InternalLogicErrorException("Root build node cannot be found");
                }
                try
                {
                    var ev = new Evaluator(evaluationState, rootNode, rootNode);
                    directories = ev.EvaluateVariableReferenceSourceCode(variableName)
                        .CheckedCast<NactList>().NactToArray<FilePath>().ToArray();
                }
                catch (ErrorException)
                {
                    // TORIAEZU: TestRunner が生成した nact ルールを与えてもエラーにならないように回避
                    // throw new InternalLogicErrorException(string.Format("Unexpected definition of {0}", variableName), ex);
                    directories = Array.Empty<FilePath>();
                }
            }
            return directories;
        }
    }
}
