﻿using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace SigloNact.Utilities
{
    static class ConvertShowIncludesUtil
    {
        private static readonly Regex s_IncludeSearchPattern = new Regex(@"^[^: ]+: [^:]+:", RegexOptions.Compiled);

        public static (IReadOnlyCollection<string> includeLines, IReadOnlyCollection<string> notIncludeLines) PartitionMsvcShowIncludes(IEnumerable<string> lines)
        {
            var includeLines = new List<string>();
            var notIncludeLines = new List<string>();

            // 1行目はソースファイル名が出力されるので無視する
            foreach (var line in lines.Skip(1))
            {
                if (line.IndexOf(@") : ", StringComparison.Ordinal) >= 0 || line.IndexOf(@"): ", StringComparison.Ordinal) >= 0 || !(s_IncludeSearchPattern.IsMatch(line)))
                {
                    notIncludeLines.Add(line);
                }
                else
                {
                    includeLines.Add(line);
                }
            }

            return (includeLines, notIncludeLines);
        }

        public static IEnumerable<string> ParseMsvcShowIncludes(IEnumerable<string> lines)
        {
            const int MsvcIncludefilePosition = 3;
            var delimiter = new[] { ' ' };

            var (includeLines, _) = PartitionMsvcShowIncludes(lines);
            var files = includeLines.Select(line => line.Split(delimiter, MsvcIncludefilePosition + 1))
                .Where(lineComponent => lineComponent.Length > MsvcIncludefilePosition)
                .Select(lineComponent => lineComponent[MsvcIncludefilePosition].Trim());
            // ファイルパスとして存在しない文字列は無視する
            return files.Where(file => File.Exists(file));
        }

        public static IEnumerable<FilePath> GetFilteredPaths(IEnumerable<FilePath> paths, IEnumerable<FilePath> filterPaths)
        {
           return paths.Where(path => filterPaths.All(y => !y.IsSameOrAncestorOf(path)));
        }
    }
}
