﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using SigloNact.Build;
using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Text;

namespace SigloNact.BuiltIns.ToolChain.GccClang
{
    [NactConstants]
    public sealed class GccClangToolChainSpecifier : INactObject
    {
        public ImmutableArray<object> NactObjectCreationArguments { get; }
        public ToolChainKind ToolChainKind { get; }
        public FilePath ToolChainRoot { get; }
        public string Architecture { get; }
        public bool IsPic { get; }

        [NactObjectCreator]
        public GccClangToolChainSpecifier(
            string toolChainKind,
            FilePath toolChainRoot,
            string architecture,
            bool isPic)
        {
            this.NactObjectCreationArguments = ImmutableArray.Create<object>(
                toolChainKind,
                toolChainRoot,
                architecture,
                isPic);

            this.ToolChainKind = Util.ParseEnum<ToolChainKind>(toolChainKind);
            this.ToolChainRoot = toolChainRoot;
            this.Architecture = architecture;
            this.IsPic = isPic;
        }
    }

    //Arm? architecture? Target?
    //そもそも分類にあまり意味がない。共通、コンパイル・アーカイブ・リンク程度。
    [NactConstants]
    public sealed class GccClangArchitectureParameters : INactObject
    {
        public ImmutableArray<object> NactObjectCreationArguments { get; }
        public string Architecture { get; }
        public string Cpu { get; }
        public string Abi { get; }
        public bool UseNeon { get; }

        [NactObjectCreator]
        public GccClangArchitectureParameters(
            string architecture,
            string cpu,
            string abi,
            bool useNeon)
        {
            this.NactObjectCreationArguments = ImmutableArray.Create<object>(
                architecture,
                cpu,
                abi,
                useNeon);

            this.Architecture = architecture;
            this.Cpu = cpu;
            this.Abi = abi;
            this.UseNeon = useNeon;
        }
    }

    [NactConstants]
    public sealed class SystemLibrary : INactObject
    {
        public ImmutableArray<object> NactObjectCreationArguments { get; }
        public string Name { get; }

        [NactObjectCreator]
        public SystemLibrary(
            string name)
        {
            this.NactObjectCreationArguments = ImmutableArray.Create<object>(name);

            this.Name = name;
        }
    }
}
