﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using SigloNact.Utilities;
using System.IO;

namespace SigloNact.BuiltIns.Target
{
    [NactActionFunctionContainer]
    public static class MakeFirmwareRevisionTextContainer
    {
        [NactActionFunction]
        public static NactActionResult MakeFirmwareRevisionText(
            INactActionContext context,
            FilePath outputFile,
            FilePath revisionInfoFile)
        {
            var helper = context.Helper;

            var revisionInfo = DataContractSerializationUtil.DeserializeFromBytes<GitRevisionInfo>(helper.ReadAllBytes(revisionInfoFile));

            using (var sw = new StreamWriter(helper.CreateFile(outputFile)))
            {
                sw.Write(revisionInfo.CommitHash);
            }

            return helper.FinishAsSuccess();
        }
    }
}
