﻿using Nintendo.Nact.FileSystem;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Plugin;
using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Nintendo.Nact.Execution;

namespace SigloNact.BuiltIns.ResultTools
{
    [NactAction]
    public class MakeJsResultFile : INactAction
    {
        private readonly IEnumerable<IReadOnlyDictionary<string, object>> m_ResultScriptPathsAndPackageNames;
        private readonly FilePath m_OutputPath;
        private readonly FilePath m_ModuleMapFilePath;
        private readonly string m_VariableName;

        public ImmutableArray<object> NactObjectCreationArguments { get; }

        [NactFunction]
        public IEnumerable<object> SkipIfNotModified => NactBuiltInUtil.ConcatList(
            ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames),
            ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames).Select(x => x.PathString),
            ResultGenerator.MakeSkipIfText(m_ResultScriptPathsAndPackageNames),
            m_ModuleMapFilePath,
            m_ModuleMapFilePath.PathString,
            m_VariableName
        );

        [NactObjectCreator]
        public MakeJsResultFile(
            IEnumerable<IReadOnlyDictionary<string, object>> resultScriptPathsAndPackageNames,
            FilePath outputPath,
            FilePath moduleMapFilePath,
            string variableName)
        {
            NactObjectCreationArguments = ImmutableArray.Create<object>(
                resultScriptPathsAndPackageNames,
                outputPath,
                moduleMapFilePath,
                variableName);

            m_ResultScriptPathsAndPackageNames = resultScriptPathsAndPackageNames;
            m_OutputPath = outputPath;
            m_ModuleMapFilePath = moduleMapFilePath;
            m_VariableName = variableName;
        }

        public NactActionResult Execute(INactActionContext context)
        {
            return ResultGenerator.InvokeWithHandleError(m_ModuleMapFilePath, () =>
            {
                ResultGenerator.MakeJsResultFile(
                    m_ResultScriptPathsAndPackageNames,
                    m_OutputPath,
                    m_ModuleMapFilePath,
                    m_VariableName);

                return NactActionResult.CreateSuccess(
                    new[] { m_ModuleMapFilePath }.Concat(ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames)).ToArray(),
                    new[] { m_OutputPath });
            });
        }
    }
}
