﻿using Nintendo.Nact.FileSystem;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Plugin;
using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Nintendo.Nact.Execution;

namespace SigloNact.BuiltIns.ResultTools
{
    [NactAction]
    public class MakeJsResultAndReferenceInfoFile : INactAction
    {
        private readonly IEnumerable<IReadOnlyDictionary<string, object>> m_ResultScriptPathsAndPackageNames;
        private readonly FilePath m_OutputPath;
        private readonly FilePath m_ModuleMapFilePath;
        private readonly string m_VariableName;
        private readonly FilePath m_TagPath;

        public ImmutableArray<object> NactObjectCreationArguments { get; }

        [NactFunction]
        public IEnumerable<object> SkipIfNotModified => NactBuiltInUtil.ConcatList(
            ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames),
            ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames).Select(x => x.PathString),
            ResultGenerator.MakeSkipIfText(m_ResultScriptPathsAndPackageNames),
            m_ModuleMapFilePath,
            m_ModuleMapFilePath.PathString,
            m_VariableName,
            m_TagPath,
            m_TagPath.PathString
        );

        [NactObjectCreator]
        public MakeJsResultAndReferenceInfoFile(
            IEnumerable<IReadOnlyDictionary<string, object>> resultScriptPathsAndPackageNames,
            FilePath outputPath,
            FilePath moduleMapFilePath,
            string variableName,
            FilePath tagPath)
        {
            m_ResultScriptPathsAndPackageNames = resultScriptPathsAndPackageNames;
            m_OutputPath = outputPath;
            m_ModuleMapFilePath = moduleMapFilePath;
            m_VariableName = variableName;
            m_TagPath = tagPath;

            NactObjectCreationArguments = ImmutableArray.Create<object>(
                resultScriptPathsAndPackageNames,
                outputPath,
                moduleMapFilePath,
                variableName,
                tagPath);
        }

        public NactActionResult Execute(INactActionContext context)
        {
            return ResultGenerator.InvokeWithHandleError(m_ModuleMapFilePath, () =>
            {
                ResultGenerator.MakeJsResultAndReferenceInfoFile(
                    m_ResultScriptPathsAndPackageNames,
                    m_OutputPath,
                    m_ModuleMapFilePath,
                    m_VariableName,
                    m_TagPath);

                return NactActionResult.CreateSuccess(
                    new[] { m_ModuleMapFilePath, m_TagPath }.Concat(ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames)).ToArray(),
                    new[] { m_OutputPath });
            });
        }
    }
}
