﻿using Nintendo.Nact.FileSystem;
using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Plugin;
using Nn.ResultTool;
using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml;
using Nintendo.Nact.Execution;

namespace SigloNact.BuiltIns.ResultTools
{
    [NactAction]
    public class MakeCppResultFile : INactAction
    {
        private readonly IEnumerable<IReadOnlyDictionary<string, object>> m_ResultScriptPathsAndPackageNames;
        private readonly FilePath m_OutputPath;
        private readonly FilePath m_ModuleMapFilePath;
        private readonly string m_PackageName;
        private readonly FilePath m_HeaderTemplatePath;

        public ImmutableArray<object> NactObjectCreationArguments { get; }

        [NactFunction]
        public IEnumerable<object> SkipIfNotModified => NactBuiltInUtil.ConcatList(
            ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames),
            ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames).Select(x => x.PathString),
            ResultGenerator.MakeSkipIfText(m_ResultScriptPathsAndPackageNames),
            m_ModuleMapFilePath,
            m_ModuleMapFilePath.PathString,
            m_PackageName,
            m_HeaderTemplatePath,
            m_HeaderTemplatePath.PathString
        );

        [NactObjectCreator]
        public MakeCppResultFile(
            IEnumerable<IReadOnlyDictionary<string, object>> resultScriptPathsAndPackageNames,
            FilePath outputPath,
            FilePath moduleMapFilePath,
            string packageName,
            FilePath headerTemplatePath)
        {
            NactObjectCreationArguments = ImmutableArray.Create<object>(
                resultScriptPathsAndPackageNames,
                outputPath,
                moduleMapFilePath,
                packageName,
                headerTemplatePath);

            m_ResultScriptPathsAndPackageNames = resultScriptPathsAndPackageNames;
            m_OutputPath = outputPath;
            m_ModuleMapFilePath = moduleMapFilePath;
            m_PackageName = packageName;
            m_HeaderTemplatePath = headerTemplatePath;
        }

        public NactActionResult Execute(INactActionContext context)
        {
            return ResultGenerator.InvokeWithHandleError(m_ModuleMapFilePath, () =>
            {
                ResultGenerator.MakeCppResultFile(
                    m_ResultScriptPathsAndPackageNames,
                    m_OutputPath,
                    m_ModuleMapFilePath,
                    m_PackageName,
                    m_HeaderTemplatePath);

                return NactActionResult.CreateSuccess(
                    new[] { m_ModuleMapFilePath, m_HeaderTemplatePath }.Concat(ResultGenerator.EnumerateScriptPaths(m_ResultScriptPathsAndPackageNames)).ToArray(),
                    new[] { m_OutputPath });
            });
        }
    }
}
