﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System;
using System.Linq;
using System.Threading;

namespace SigloNact.BuiltIns.Prebuilt
{
    [NactActionFunctionContainer]
    public static class ResolvePrebuiltContainer
    {
        [NactActionFunction]
        public static NactActionResult ResolvePrebuilt(
            INactActionContext context,
            string baseUri,
            FilePath outputDirectory,
            FilePath baseRevisionFile,
            string searchAncestorCount,
            string locator,
            string fields)
        {
            var helper = context.Helper;

            if (!RequestResolver.Resolve(
                context.Helper,
                baseUri,
                outputDirectory,
                baseRevisionFile,
                searchAncestorCount,
                locator,
                fields))
            {
                return helper.FinishAsFailure();
            }

            return helper.FinishAsSuccess();
        }
    }
}
