﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System;
using System.Collections.Generic;
using System.Text;

namespace SigloNact.BuiltIns.Prebuilt
{
    [NactActionFunctionContainer]
    public static class PrintPrebuiltResultsContainer
    {
        [NactActionFunction]
        public static NactActionResult PrintPrebuiltResults(
            INactActionContext context,
            FilePath dummyOutputPath,
            FilePath baseRevisionFile,
            string searchAncestorCount,
            string locator,
            string fields,
            FilePath buildIdFile,
            FilePath revisionFile,
            FilePath artifactUriFile,
            FilePath webUrlFile)
        {
            var helper = context.Helper;

            var infoText = string.Format(
                Strings.Prebuilt_ResultsInformation,
                helper.ReadAllText(baseRevisionFile, Encoding.ASCII),
                searchAncestorCount,
                locator,
                fields,
                helper.ReadAllText(buildIdFile, Encoding.ASCII),
                helper.ReadAllText(revisionFile, Encoding.ASCII),
                helper.ReadAllText(artifactUriFile, Encoding.ASCII),
                helper.ReadAllText(webUrlFile, Encoding.ASCII));

            Nintendo.Nact.Utilities.Log.Message(infoText);

            // メッセージをテキストファイルに出力しておく。
            // 出力ファイルの形式が現在のカルチャに依存するのは、厳密には望ましくない。
            // Siglo ビルドシステムではこの内容が機械にパースされることを意図していないので、よいことにする。
            helper.WriteAllText(dummyOutputPath, infoText, Encoding.UTF8);

            return helper.FinishAsSuccess();
        }
    }
}
