﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Prebuilt
{
    internal static class Downloader
    {
        [Serializable]
        public class DownloaderException : Exception
        {
            public DownloaderException()
                : base()
            {
            }

            public DownloaderException(string message)
                : base(message)
            {
            }

            protected DownloaderException(SerializationInfo info, StreamingContext context)
                : base(info, context)
            {
            }

            public DownloaderException(string message, Exception innerException)
                : base(message, innerException)
            {
            }
        }

        public class WebClientWithTimeout : WebClient
        {
            protected override WebRequest GetWebRequest(Uri address)
            {
                var req = base.GetWebRequest(address);
                req.Timeout = 10 * 60 * 1000;    // 10 minutes in ms
                return req;
            }
        }

        public static void Download(
            INactActionHelper helper,
            FilePath outputFile,
            string sourceUri)
        {
            try
            {
                Authorization.AuthenticationInfo authenticationInfo;

                try
                {
                    authenticationInfo = Authorization.FindAuthenticationInfo(PrebuiltUtility.GetAuthorizationTargetName());
                }
                catch (Authorization.AuthorizationException e)
                {
                    throw new DownloaderException(string.Format("Failed to get an account. Please execute 'Integrate/CommandLineTools/CredentialRegister.exe' and register your account."), e);
                }

                helper.Out.Write("================================================================================\n");
                helper.Out.Write("{0}\n", PrebuiltUtility.GetMessageOfAnnouncementOfSkipDownloadPrebuiltResultsOption());
                helper.Out.Write("\n");
                helper.Out.Write("{0}\n", PrebuiltUtility.GetMessageOfAnnouncementOfDetailsPage());
                helper.Out.Write("================================================================================\n");

                try
                {
                    using (var client = new WebClientWithTimeout())
                    using (var outputStream = helper.CreateFile(outputFile))
                    {
                        client.Credentials = new System.Net.NetworkCredential(authenticationInfo.Username, authenticationInfo.Password);
                        using (var inputStream = client.OpenRead(sourceUri))
                        {
                            inputStream.CopyTo(outputStream);
                        }
                    }

                    var info = new FileInfo(outputFile.PathString);

                    if (!(info.Exists && info.Length > 0))
                    {
                        helper.DeleteFile(outputFile, true);

                        throw new DownloaderException(PrebuiltUtility.GenerateErrorMessage("Failed to download a file.", authenticationInfo.Username, authenticationInfo.Password, sourceUri));
                    }
                }
                catch (WebException e)
                {
                    throw new DownloaderException(PrebuiltUtility.GenerateErrorMessage(e.Message, authenticationInfo.Username, authenticationInfo.Password, sourceUri), e);
                }
            }
            catch (Exception e)
            {
                helper.Out.Write("================================================================================\n");
                helper.Out.Write("error: {0}\n", e.Message);
                helper.Out.Write("\n");
                helper.Out.Write("{0}\n", PrebuiltUtility.GetMessageOfAnnouncementOfDetailsPage());
                helper.Out.Write("================================================================================\n");
                throw;
            }
        }
    }
}
