﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System;
using System.Linq;
using System.Text;
using System.Threading;
using static System.FormattableString;

namespace SigloNact.BuiltIns.Prebuilt
{
    // アーカイブ名から、リソース URI を求めます。
    // @public GetArchiveUriFromArchiveName = archiveName => FormatString("{0}/{1}.zip", ${ArtifactUri}, ${archiveName});

    [NactActionFunctionContainer]
    public static class DownloadPrebuiltContainer
    {
        [NactActionFunction]
        public static NactActionResult DownloadPrebuilt(
            INactActionContext context,
            FilePath outputFile,
            FilePath artifactUriFile,
            string archiveName)
        {
            var helper = context.Helper;

            var artifactUri = helper.ReadAllText(artifactUriFile, Encoding.ASCII);
            var sourceUri = Invariant($"{artifactUri}/{archiveName}.zip");
            Downloader.Download(helper, outputFile, sourceUri);

            return helper.FinishAsSuccess();
        }
    }
}
