﻿using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Common
{
    [NactFunctionContainer]
    public static class GetIndexOfNearestListContainer
    {
        // 文字列のリストの集合 map の中で、リスト target と最も多くの同じ要素を持つリストのインデックスを返します
        // 複数のリストが条件に合致した場合は最も要素数が少ないリストが選ばれ、それでも複数のリストが条件に合致する場合には -1 を返します
        [NactFunction]
        public static double GetIndexOfNearestList(IEnumerable<string> target, IEnumerable<IEnumerable<string>> map)
        {
            var targetHashset = new HashSet<string>(target);

            int matchCountMax = 0;
            int index = 0;
            int mapIndex = 0;
            bool error = false;

            foreach (var list in map)
            {
                var hashset = new HashSet<string>(list);
                int count = hashset.Where(x => targetHashset.Contains(x)).Count();

                if (count > matchCountMax)
                {
                    matchCountMax = count;
                    index = mapIndex;
                    error = false;
                }
                else if (count == matchCountMax)
                {
                    if (hashset.Count() < map.ElementAt(index).Count())
                    {
                        index = mapIndex;
                        error = false;
                    }
                    else if (mapIndex != index && hashset.Count() == map.ElementAt(index).Count())
                    {
                        error = true;
                    }
                }
                mapIndex++;
            }

            return error ? -1.0 : (double)index;
        }
    }
}
