﻿using Nintendo.Nact.BuiltIn;

namespace SigloNact.BuiltIns.BuildSystem
{
    [NactFunctionContainer]
    public static class TargetRuleAggregatorFunctions
    {
        [NactFunction]
        public static object CopyDirectoryAggregator(
            string[][][] inputs,
            bool[] activenesses)
        {
            return new CopyDirectoryAggregator().Execute(inputs, activenesses);
        }

        [NactFunction]
        public static object CopyFileAggregator(
            string[][][] inputs,
            bool[] activenesses)
        {
            return new CopyFileAggregator().Execute(inputs, activenesses);
        }

        [NactFunction]
        public static object ProgramExecutionAggregator(
            string[][][][] inputs,
            bool[] activenesses)
        {
            return new ProgramExecutionAggregator().Execute(inputs, activenesses);
        }

        [NactFunction]
        public static object ResourceConversionRuleAggregator(
            string[][][][] inputs,
            bool[] activenesses)
        {
            return new ResourceConversionRuleAggregator().Execute(inputs, activenesses);
        }
    }
}
