﻿using Nintendo.Nact.Values;
using Nintendo.Nact.NactInterop;
using System;
using System.Collections.Generic;
using System.Linq;
using static Nintendo.Nact.Extensions.NactValueExtensions;

namespace SigloNact.BuiltIns.BuildSystem
{
    public abstract class TargetRuleAggregator<TNactValue, TScriptValue, TGroupKey>
        where TGroupKey : IEquatable<TGroupKey>
    {
        public abstract TScriptValue Translate(TNactValue input);

        public abstract TGroupKey GetGroupKey(TScriptValue data);

        public abstract void Validate(TScriptValue[] group);

        public abstract object Translate(TScriptValue output);

        public object Execute(TNactValue[][] inputs, bool[] activenesses)
        {
            var pairedInputs = inputs.Zip(activenesses, (i, a) => Tuple.Create(i, a)).SelectMany(x => x.Item1.Select(i => Tuple.Create(this.Translate(i), x.Item2)));

            var groups = pairedInputs.GroupBy(x => GetGroupKey(x.Item1));

            foreach (var group in groups)
            {
                this.Validate(group.Select(x => x.Item1).ToArray());
            }

            return groups.Select(g => new object[] { this.Translate(g.First().Item1), g.Select(x => x.Item2).Any(x => x) }).ToArray();
        }
    }

    [Serializable]
    public class TargetRuleAggregatorException : Nintendo.Nact.ErrorException
    {
        public TargetRuleAggregatorException(string msg)
            : base(msg)
        {
        }
    }
}
