﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using SigloNact.Build;
using System;

namespace SigloNact.BuiltIns.BuildSystem
{
    [NactFunctionContainer]
    public static class EnumFunctions
    {
        [NactFunction]
        public static string FilePathToCompileLanguage(FilePath path)
        {
            switch (path.Extension)
            {
                case ".cpp":
                case ".cc":
                case ".h":
                case ".hpp":
                    return nameof(CompileLanguage.Cxx);
                case ".c":
                    return nameof(CompileLanguage.C);
                case ".S":
                    return nameof(CompileLanguage.Asm);
                default:
                    throw new ArgumentException(string.Format("Unknown file extension {0}.", path.Extension));
            }
        }
    }
}
