﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.SigloBuild.Settings
{
    public sealed class ToolChain
    {
        public string Id { get; }
        public string Version { get; }

        internal ToolChain(XElement toolChainElement)
        {
            this.Id = toolChainElement.Attribute("id")?.Value
                ?? throw new InvalidBuildSettingsFileException("'ToolChain' element must have an 'id' attribute.");
            this.Version = toolChainElement.Element("Version")?.Value
                ?? throw new InvalidBuildSettingsFileException("'ToolChain' element must have a 'Version' element."); ;
        }
    }
}
