﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject
{
    public class ProjectConfiguration : IEquatable<ProjectConfiguration>
    {
        public string Platform { get; private set; }
        public string Configuration { get; private set; }

        public ProjectConfiguration(string configuration, string platform)
        {
            if (platform == null)
            {
                throw new ArgumentNullException("platform");
            }
            if (configuration == null)
            {
                throw new ArgumentNullException("configuration");
            }

            Platform = platform;
            Configuration = configuration;
        }

        public override string ToString()
        {
            return string.Format("{0}|{1}", Configuration, Platform);
        }

        #region IEquatable 関係
        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }
            else if (obj is ProjectConfiguration)
            {
                return Equals((ProjectConfiguration)obj);
            }
            else
            {
                return false;
            }
        }
        public bool Equals(ProjectConfiguration other)
        {
            if (other == null)
            {
                return false;
            }
            else
            {
                return Platform == other.Platform && Configuration == other.Configuration;
            }
        }
        public static bool operator ==(ProjectConfiguration lhs, ProjectConfiguration rhs)
        {
            if ((object)lhs == null || (object)rhs == null)
            {
                return object.ReferenceEquals(lhs, rhs);
            }
            else
            {
                return lhs.Equals(rhs);
            }
        }
        public static bool operator !=(ProjectConfiguration lhs, ProjectConfiguration rhs)
        {
            if ((object)lhs == null || (object)rhs == null)
            {
                return !object.ReferenceEquals(lhs, rhs);
            }
            else
            {
                return !lhs.Equals(rhs);
            }
        }
        public override int GetHashCode()
        {
            var nameHash = Platform != null ? Platform.GetHashCode() : 0;
            var valueHash = Configuration != null ? Configuration.GetHashCode() : 0;
            return nameHash ^ valueHash;
        }
        #endregion
    }
}
