﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition.Hosting;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Construction;
using Nintendo.MakeVisualStudioProject.Converter;
using Nintendo.MakeVisualStudioProject.Generator;

namespace Nintendo.MakeVisualStudioProject
{
    internal class Program
    {
        public static CommandLineOption Option { get; private set; }

        public static CompositionContainer CompositionContainer { get; private set; }

        private static void Main(string[] args)
        {
            AppDomain.CurrentDomain.UnhandledException += UnhandledExceptionHandler;

            CreateCompositionContainer();

            try
            {
                Option = CommandLineOption.Parse(args);

                if (Option == null)
                {
                    // ヘルプメッセージを表示したので終了
                    Environment.Exit(0);
                }
            }
            catch (ArgumentException)
            {
                // コマンドラインオプションのパースに失敗したので終了
                Environment.Exit(1);
            }

            var commandParameter = Option.GetCommandParameter();
            if (commandParameter != null)
            {
                var command = commandParameter.CreateCommand();
                command.Execute();
            }
            else
            {
                throw new NotImplementedException();
            }

            Environment.Exit(0);
        }

        private static void CreateCompositionContainer()
        {
            var thisAssembly = System.Reflection.Assembly.GetExecutingAssembly();

            var catalog = new AggregateCatalog();
            catalog.Catalogs.Add(new AssemblyCatalog(thisAssembly));
            catalog.Catalogs.Add(new DirectoryCatalog(Path.GetDirectoryName(thisAssembly.Location), "MakeVisualStudioProject.NX.dll"));

            CompositionContainer = new CompositionContainer(catalog);
        }

        private static void UnhandledExceptionHandler(object sender, UnhandledExceptionEventArgs e)
        {
            var ex = e.ExceptionObject as Exception;
            if (ex != null)
            {
                Log.Error(ex.ToString());
            }
            else
            {
                Log.Error(e.ToString());
            }

            if (System.Diagnostics.Debugger.IsAttached)
            {
                System.Diagnostics.Debugger.Break();
            }
            else
            {
                Environment.Exit(1);
            }
        }
    }
}
