﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public class OptionValue : IEquatable<OptionValue>
    {
        public string Switch { get; private set; }
        public string Argument { get; private set; }

        public bool HasArgument
        {
            get
            {
                return Argument != null;
            }
        }

        public OptionValue(string s)
            : this(s, null)
        {
        }
        public OptionValue(string s, string a)
        {
            if (s == null)
            {
                throw new ArgumentNullException("switch");
            }

            Switch = s;
            Argument = a;
        }

        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.AppendFormat("Switch = {0}", Switch);
            if (HasArgument)
            {
                sb.AppendFormat(", Argument = {0}", Argument);
            }
            return sb.ToString();
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }
            if (obj is OptionValue)
            {
                return Equals((OptionValue)obj);
            }
            return false;
        }
        public bool Equals(OptionValue other)
        {
            if (other == null)
            {
                return false;
            }
            return this.Switch == other.Switch && this.Argument == other.Argument;
        }
        public static bool operator ==(OptionValue lhs, OptionValue rhs)
        {
            if ((object)lhs == null || (object)rhs == null)
            {
                return object.ReferenceEquals(lhs, rhs);
            }
            else
            {
                return lhs.Equals(rhs);
            }
        }
        public static bool operator !=(OptionValue lhs, OptionValue rhs)
        {
            if ((object)lhs == null || (object)rhs == null)
            {
                return !object.ReferenceEquals(lhs, rhs);
            }
            else
            {
                return !lhs.Equals(rhs);
            }
        }
        public override int GetHashCode()
        {
            return Switch.GetHashCode() ^ (Argument != null ? Argument.GetHashCode() : 0);
        }
    }
}
