﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public class ItemMetadata : IEquatable<ItemMetadata>
    {
        public string Name { get; private set; }
        public string Value { get; private set; }

        public ItemMetadata(string name, string value)
        {
            if (name == null)
            {
                throw new ArgumentNullException("name");
            }
            if (value == null)
            {
                throw new ArgumentNullException("value");
            }

            Name = name;
            Value = value;
        }

        public override string ToString()
        {
            return string.Format("Name = {0}, Value = {1}", Name, Value);
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }
            if (obj is ItemMetadata)
            {
                return Equals((ItemMetadata)obj);
            }
            return false;
        }
        public bool Equals(ItemMetadata other)
        {
            if (other == null)
            {
                return false;
            }
            return this.Name == other.Name && this.Value == other.Value;
        }
        public static bool operator ==(ItemMetadata lhs, ItemMetadata rhs)
        {
            if ((object)lhs == null || (object)rhs == null)
            {
                return object.ReferenceEquals(lhs, rhs);
            }
            else
            {
                return lhs.Equals(rhs);
            }
        }
        public static bool operator !=(ItemMetadata lhs, ItemMetadata rhs)
        {
            if ((object)lhs == null || (object)rhs == null)
            {
                return !object.ReferenceEquals(lhs, rhs);
            }
            else
            {
                return !lhs.Equals(rhs);
            }
        }
        public override int GetHashCode()
        {
            return Name.GetHashCode() ^ Value.GetHashCode();
        }
    }
}
