﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Construction;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public interface IPlatformElementConverter
    {
        void SetProjectPathInfo(string projectDirectory, IDictionary<string, string> substitutionPaths);

        bool AcceptsBuildTargetSetting(BuildTargetSetting targetSetting);

        void AddCompileOptionMetadatas(ProjectItemElement clCompile, IEnumerable<string> compileOptions, BuildTargetSetting targetSetting);
        IEnumerable<string> ReadCompileOptionMetadatas(ProjectItemElement clCompile, BuildTargetSetting targetSetting);

        void AddCustomProperties(ProjectPropertyGroupElement propertyGroup, BuildTargetSetting targetSetting);
        void ReadCustomProperties(ProjectPropertyGroupElement propertyGroup, BuildTargetSetting targetSetting);

        void AddCustomItemDefinitions(ProjectItemDefinitionGroupElement itemDefinitionGroup, VcProjectConfigurationType type, BuildTargetSetting targetSetting);
        void ReadCustomItemDefinitions(ProjectItemDefinitionGroupElement itemDefinitionGroup, VcProjectConfigurationType type, BuildTargetSetting targetSetting);
    }

    public interface IPlatformElementConverterMetadata
    {
        string SupportedPlatform { get; }
    }

    public interface IBuiltinOptionDefinitionsAvailable
    {
        bool UseBuiltinOptionDefinitions { get; set; }
    }
}
