﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    internal class CafeOptionConverter : OptionConverter
    {
        public static CafeOptionConverter GetCompilerOptionConverter(string vcToolsVersion = null, string vsVersion = null)
        {
            return new CafeOptionConverter(GenerateOptionDefinitions("Compiler2012-1_1_0_0.xml", vcToolsVersion, vsVersion));
        }

        public static CafeOptionConverter GetLibrarianOptionConverter(string vcToolsVersion = null, string vsVersion = null)
        {
            return new CafeOptionConverter(GenerateOptionDefinitions("Librarian2012-1_1_0_0.xml", vcToolsVersion, vsVersion));
        }

        public static CafeOptionConverter GetLinkerOptionConverter(string vcToolsVersion = null, string vsVersion = null)
        {
            return new CafeOptionConverter(GenerateOptionDefinitions("Linker2012-1_1_0_0.xml", vcToolsVersion, vsVersion));
        }

        private CafeOptionConverter(IEnumerable<OptionDefinition> ods)
        {
            this.OptionStringConverter = new CafeOptionStringConverter(ods);
            this.ItemMetadataConverter = new CafeItemMetadataConverter(ods);
        }

        private static IEnumerable<OptionDefinition> GenerateOptionDefinitions(string filename, string vcToolsVersion = null, string vsVersion = null)
        {
            var vcv = vcToolsVersion ?? "4.0";
            var vsv = vsVersion ?? "110";

            var vcTargetsPath = OptionDefinitionGenerator.GetVCTargetsPath(vcv, vsv);
            var lcid = System.Globalization.CultureInfo.InstalledUICulture.LCID.ToString();
            var xmlPath = Path.Combine(vcTargetsPath, @"Platforms\Cafe\Targets", lcid, filename);

            try
            {
                return OptionDefinitionGenerator.Generate(xmlPath);
            }
            catch (Exception ex)
            {
                if (ex is FileNotFoundException || ex is DirectoryNotFoundException)
                {
                    throw new ConversionException(
                        "MULTI ツールチェインのコマンドラインオプション定義を生成できません。VSI-Cafe がインストールされていることを確認してください。", ex);
                }
                else
                {
                    throw;
                }
            }
        }
    }
}
