﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.MakeVisualStudioProject
{
    internal class CommandLineOption
    {
        [CommandLineSubCommand(
            "generate",
            Description = "プロジェクト設定ファイルからプロジェクトファイルを生成します。")]
        public Generator.GenerateCommand.CommandParameter GenerateCommandParameter { get; private set; }

        public ICommandParameter GetCommandParameter()
        {
            if (GenerateCommandParameter != null)
            {
                return GenerateCommandParameter;
            }

            return null;
        }

        public static CommandLineOption Parse(string[] args)
        {
            var parser = new CommandLineParser();

            CommandLineOption option;
            var continues = parser.ParseArgs(args, out option);

            if (continues)
            {
                return option;
            }
            else
            {
                return null;
            }
        }
    }
}
