@echo off

setlocal
set REPOSITORY_ROOT=%~dp0..\..\..\..\..\..\..\

set LOCATE_VS_INSTALLATION=%REPOSITORY_ROOT%Integrate\CommandLineTools\LocateVsInstallation.exe
for /f "delims=" %%I in ('%LOCATE_VS_INSTALLATION%') do set VS2017_LOCATION=%%I
if not exist "%VS2017_LOCATION%" goto :error_vs

set CSI_LOCATION=%VS2017_LOCATION%\MSBuild\15.0\Bin\Roslyn\csi.exe
if not exist "%CSI_LOCATION%" goto :error_csi

set GENERATOR_ASSEMBLY=%REPOSITORY_ROOT%Programs\Alice\Outputs\AnyCPU\Tools\MakeVisualStudioProject\MakeVisualStudioProject.OptionGeneration\Release\MakeVisualStudioProject.OptionGeneration.dll
if not exist "%GENERATOR_ASSEMBLY%" goto :error_gen_asm

"%CSI_LOCATION%" /r:"%GENERATOR_ASSEMBLY%" "%~dp0Generate.csx"
if %ERRORLEVEL% NEQ 0 pause
exit /B %ERRORLEVEL%


:error_vs
echo Cannot find Visual Studio 2017. Please install it.
pause
exit /B 1

:error_csi
echo Cannot find csi.exe. Please install it with Visual Studio 2017.
pause
exit /B 1

:error_gen_asm
echo MakeVisualStudioProject.OptionGeneration.dll not found. Please build it first.
pause
exit /B 1
